#!/bin/sh

# This script extracts the icon from an executable file and uses that 
# icon to represent the application in the file viewer.  Currently, only
# ELF executables created by 'elficon' are supported.
#
# Inputs:
#  1) Image Size Request
#  2) Executable File
#  3) Temporary Output File
DEFAULT_ICON=/usr/share/icons/gnome/scalable/mimetypes/application-x-executable.svg
#DEBUG_OUTPUT=/home/${USER}/thumbnail.txt
DEBUG_OUTPUT=/dev/null

DATE=`date`;
echo "${DATE}: elficon -f \"$2\" \"$1\" \"$3\"" >> ${DEBUG_OUTPUT};
rm "$3";
elficon -f "$2" "$1" "$3" 2>> ${DEBUG_OUTPUT};
# GNOME will not ever regenerate an icon for a "failed" thumbnail,
# so to work around this problem we now always generate a thumbnail.
if [ ! -e "$3" ]; then
	echo "No image, using default." >> ${DEBUG_OUTPUT};
	cp "${DEFAULT_ICON}" "$3";
fi

